" Vim syntax file
" Language:	MEL (Maya Extension Language)
" Maintainer:	Robert Minsk <egbert@centropolisfx.com>
" Last Change:	May 27 1999
" Based on:	Bram Moolenaar <Bram@vim.org> C syntax file

" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

" when wanted, highlight trailing white space and spaces before tabs
if exists("zsc_space_errors")
  sy match	zscSpaceError	"\s\+#"
  sy match	zscSpaceError	" \+\t"me=e-1
endif

" A bunch of usefull ZSCRIPT keywords
sy match	zscIdentifier	"\#\(\a\|_\)\w*"
sy keyword	zscUI		IButton ISlider ISwitch ISubPalette ButtonFind ButtonPress ButtonSet ButtonUnPress
sy keyword	zscNote		Note NoteBar NoteIButton NoteIGet NoteISwitch MessageOK MessageOKCancel MessageYesNo MessageYesNoCancel

sy keyword	zscCanvas	CanvasClick CanvasGyroHide CanvasGyroShow CanvasPanGetH CanvasPanGetV CanvasPanSet CanvasStroke CanvasStrokes CanvasZoomGet CanvasZoomSet PixolPick StrokeGetInfo StrokeGetLast StrokeLoad StrokesLoad TransformGet TransformSet

sy keyword	zscFunctionA	IClick IClose IColorSet IConfig IDialog IDisable IEnable IExists IFadeIn IFadeOut IGet IGetFlags IGetHotkey 
sy keyword	zscFunctionB	IGetID IGetInfo IGetMax IGetMin IGetSecondary IGetStatus IGetTitle IHeight IHide IHPos IKeyPress ILock 
sy keyword	zscFunctionC	IMaximize IMinimize IModGet IModSet IPress IReset IsDisabled IsEnabled ISet ISetHotkey ISetMax ISetMin 
sy keyword	zscFunctionD	IShow IShowActions IsLocked IStroke IsUnlocked IToggle IUnlock IUnPress IUpdate IVPos IWidth ZBrushInfo ZBrushPriorityGet ZBrushPrioritySet

sy keyword	zscMouse	MouseHPos MouseLButton MouseVPos 

sy keyword 	zscTutorialA	BackColorSet Caption FontSetColor FontSetOpacity FontSetSize FontSetSizeLarge FontSetSizeMedium FontSetSizeSmall
sy keyword	zscTutorialB	FontColorSet HotKeyText Image ISetStatus PageSetWidth PaintBackground PaintBackSliver PaintPageBreak PaintRect
sy keyword	zscTutorialC	PaintTextRect PD PenMove PenMoveCenter PenMoveDown PenMoveLeft PenMoveRight PenSetColor SectionBegin SectionEnd
sy keyword	zscTutorialD	SubTitle TextCalcWidth Title FrontColorSet GetActiveToolPath

sy keyword	zscVar		VarDef VarSet VarListCopy VarLoad VarSave Var VarAdd VarDec VarDiv VarInc VarSize VarSub VarMul

sy keyword	zscStr		StrAsk StrExtract StrFind StrFromAsc StrLength StrLower StrMerge StrToAsc StrUpper

sy keyword	zscFileA	FileExecute FileExists FileNameAdvance FileNameAsk FileNameExtract FileNameGetLastTyped FileNameMake
sy keyword	zscFileB	FileNameResolvePath FileNameSetNext FileNameGetLastUsed

sy keyword	zscMath		Interpolate INT FRAC ABS NEG MIN MAX SQRT RAND IRAND SIN COS TAN ASIN ACOS ATAN ATAN2 LOG LOG10 BOOL Randomize RGB Val

sy keyword	zscFlow		Assert Delay Exit If IFreeze Loop LoopContinue LoopExit Sleep SleepAgain zscriptinsert

sy keyword	zscProc		RoutineCall RoutineDef

sy keyword	zscMemA		MemCopy MemCreate MemCreateFromFile MemDelete MemGetSize MemMove MemMultiWrite MemRead MemReadString MemResize 
sy keyword	zscMemB		MemSaveToFile MemWrite MemWriteString MTransformGet MTransformSet MVarDef MVarGet MVarSet SoundPlay SoundStop

sy keyword	zsc3D		DispMapCreate Mesh3DGet NormalMapCreate ZSphereAdd ZSphereDel ZSphereEdit ZSphereGet ZSphereSet

" ZSCRIPT data types
sy match	zscCharSpecial	contained "\\[ntr\\"]"
sy match	zscCharError	contained "\\[^ntr\\"]"

sy region	zscString	start=+"+ skip=+\\"+ end=+"+ contains=zscCharSpecial,zscCharError

sy case ignore
sy match	zscInteger	"\<\d\+\(e[-+]\=\d\+\)\=\>"
sy match	zscFloat	"\<\d\+\(e[-+]\=\d\+\)\=f\>"
sy match	zscFloat	"\<\d\+\.\d*\(e[-+]\=\d\+\)\=f\=\>"
sy match	zscFloat	"\.\d\+\(e[-+]\=\d\+\)\=f\=\>"
sy case match

sy match	zscCommaSemi	contained "[,;]"
sy region	zscMatrixVector	start=/<</ end=/>>/ contains=zscInteger,zscFloat,zscIdentifier,zscCommaSemi

sy cluster	zscGroup	contains=zscFunction,zscStatement,zscConditional,zscLabel,zscKeyword,zscStorageClass,zscTODO,zscCharSpecial,zscCharError,zscCommaSemi

" catch errors caused by wrong parenthesis
sy region	zscParen	transparent start='(' end=')' contains=ALLBUT,@zscGroup,zscParenError,zscInParen
sy match	zscParenError	")"
sy match	zscInParen	contained "[{}]"

" comments
sy region	zscComment	start="/\*" end="\*/" contains=zscTodo,zscSpaceError
sy match	zscComment	"//.*" contains=zscTodo,zscSpaceError
sy match	zscCommentError "\*/"

sy region	zscQuestionColon matchgroup=zscConditional transparent start='?' end=':' contains=ALLBUT,@zscGroup

if !exists("zsc_minlines")
  let zsc_minlines=15
endif
exec "sy sync ccomment zscComment minlines=" . zsc_minlines

" Define the default highlighting.
" For version 5.7 and earlier: only when not done already
" For version 5.8 and later: only when an item doesn't have highlighting yet
if version >= 508 || !exists("did_zsc_syntax_inits")
  if version < 508
    let did_zsc_syntax_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command -nargs=+ HiLink hi def link <args>
  endif

  HiLink zscIdentifier  Identifier
  HiLink zscUI		Statement
  HiLink zscNote	String
  HiLink zscCanvas	Function
  HiLink zscFunctionA	Function
  HiLink zscFunctionB	Function
  HiLink zscFunctionC	Function
  HiLink zscFunctionD	Function
  HiLink zscMouse	Operator
  HiLink zscTutorialA	Operator
  HiLink zscTutorialB	Operator
  HiLink zscTutorialC	Operator
  HiLink zscTutorialD	Operator
  HiLink zscVar		Typedef
  HiLink zscStr		String
  HiLink zscFileA	Function
  HiLink zscFileB	Function
  HiLink zscMath	Macro
  HiLink zscFlow	Conditional
  HiLink zscProc	Special
  HiLink zscMemA	StorageClass
  HiLink zscMemB	StorageClass
  HiLink zsc3D		Keyword

  HiLink zscCharSpecial SpecialChar
  HiLink zscString	FoldColumn
  HiLink zscInteger	Number
  HiLink zscFloat	Float
  HiLink zscMatrixVector Float
  HiLink zscComment	Comment
  HiLink zscError	Error
  HiLink zscSpaceError	zscError
  HiLink zscCharError	zscError
  HiLink zscParenError	zscError
  HiLink zscInParen	zscError
  HiLink zscCommentError zscError

  delcommand HiLink
endif

let b:current_syntax = "zscript"
