--Small edits made by Bjorn Albihn, bjorn@albihn.net

macroScript GoMax	
category:"Norman3D"
toolTip:"GoMax"
ButtonText:"GoMax"

(
		on execute do(
					filein ("C:\\GoMax\\GoMax2.ms");
		)
)

	
macroScript ZBrush_Import
category:"Norman3D" 
tooltip:"To ZBrush"
ButtonText: "GoMax To ZBrush"
icon:#("gomax2ZB",1)

(
	on execute do
		(
		fn check_version= --return which version the user has, 11000 = max2009, 12000 = max 2010
			(
				ver = maxversion()
				return ver[1]
			)	
				
		if selection.count != 0 then -- checks if any object is selected before exporting to avoid any crashing /Bjorn
			(
			ver = check_version()
			if ver >= 12000 do -- objsettings not used in max 2010, however you must setup your OBJexport and import correctly yourself. Check above values.
				(
					theINI = objExp.getIniName()
					setIniSetting theINI "General" "UseLogging" "0"
					setIniSetting theINI "General" "Preset" ""
					setIniSetting theINI "General" "MapSearchPath=" ""
					setIniSetting theINI "Geometry" "FlipZyAxis" "1"
					setIniSetting theINI "Geometry" "Shapes" "0"
					setIniSetting theINI "Geometry" "ExportHiddenObjects" "0"
					setIniSetting theINI "Geometry" "FaceType" "1"
					setIniSetting theINI "Geometry" "TextureCoords" "1"
					setIniSetting theINI "Geometry" "Normals" "1"
					setIniSetting theINI "Geometry" "SmoothingGroups" "1"
					setIniSetting theINI "Geometry" "ObjScale" "1.000000"
					setIniSetting theINI "Material" "UseMaterial" "0"
					setIniSetting theINI "Material" "CreateMatLibrary" "0"
					setIniSetting theINI "Output" "RelativeIndex" "0"
					setIniSetting theINI "Output" "Target" "0"
					setIniSetting theINI "Output" "Precision" "6"
					setIniSetting theINI "Optimize" "optVertex" "0"
					setIniSetting theINI "Optimize" "optNormals" "0"
					setIniSetting theINI "Optimize" "optTextureCoords" "0"
					) 
				exportFile "C:\\GoMAX\\GoMAX.OBJ" #noPrompt selectedOnly:true using:ObjExp
				ShellLaunch "C:\\GoMAX\\MAX_TO_ZB.bat" ""
				gc()
				)
		else messagebox "No objects selected" --Gives a message that there is no object selected  /Bjorn	
		)
		
)				




macroScript ZBrush_Export
category:"Norman3D" 
tooltip:"From ZBrush"
ButtonText: "GoMax From ZBrush"
icon:#("gomaxfromZB",1)

(
	fn check_version= --return which version the user has, 11000 = max2009, 12000 = max 2010
	(
		ver = maxversion()
		return ver[1]
	)	
	
	fn fetch = (
	fetch2 = importFile "C:\\GoMAX\\GoMAX.OBJ" #noPrompt using:ObjImp
	if fetch2 == false then
	sleep 1
	else exit
	)


	fn uberfetch = (	
		fetch2 = importFile "C:\\GoMAX\\GoMAX.OBJ" #noPrompt using:ObjImp
	while fetch2 == false do (
		fetch() 
		if fetch2 == true then	exit)
	)

	on execute do(
		if selection.count != 0 then-- checks if any object is selected before importing, gives a message if you want to replace the object to avoid an non undoable deleting /bjorn
				(
				if queryBox "Do you want to replace your selection with current Zbrush tool?" beep:false then delete selection
				)
			ShellLaunch "C:\\GoMAX\\ZB_TO_MAX.bat" ""
			ver = check_version()
			if ver >= 12000 do -- objsettings not used in max 2010, however you must setup your OBJexport and import correctly yourself. Check above values.
				(
				theINI2 = objImp.getIniName()
				setIniSetting theINI2 "General" "UseLogging" "0"
				setIniSetting theINI2 "General" "Preset" ""
				setIniSetting theINI2 "General" "ResetScene" "0"
				setIniSetting theINI2 "General" "UseLogging" "0"
				setIniSetting theINI2 "Objects" "SingleMesh" "1"
				setIniSetting theINI2 "Objects" "AsEditablePoly" "1"
				setIniSetting theINI2 "Objects" "Retriangulate" "0"
				setIniSetting theINI2 "Geometry" "FlipZyAxis" "1"
				setIniSetting theINI2 "Geometry" "CenterPivots" "0"
				setIniSetting theINI2 "Geometry" "Shapes" "0"
				setIniSetting theINI2 "Geometry" "TextureCoords" "1"
				setIniSetting theINI2 "Geometry" "SmoothingGroups" "1"
				setIniSetting theINI2 "Geometry" "NormalsType" "0"
				setIniSetting theINI2 "Geometry" "FlipNormals" "0"
				setIniSetting theINI2 "Geometry" "ObjScale" "1.000000"
				setIniSetting theINI2 "Units/Scale" "Convert" "0"
				setIniSetting theINI2 "Units/Scale" "ObjScale" "1.000000"
				setIniSetting theINI2 "Material" "UniqueWireColor" "1"
				setIniSetting theINI2 "Material" "ImportMaterials" "0"
				) 
			uberfetch()
			if ver >= 11000 do (hiddenDosCommand "del C:\GoMAX\GoMax.obj") --works in max 2009, not max 9 
			gc()
			if ver >= 12000 do  --material setup also acts up in max 2009
				(
				loadMaterialLibrary "C:\GoMAX\Material\Zbrush_Shader.mat"
				meditMaterials[24] = DirectX_9_Shader ()
				meditMaterials[24].effectFile = "C:\GoMAX\Material\zbrush.FX"
				meditMaterials[24].renderMaterial = undefined
				meditMaterials[24].UseLitSphere = on
				meditMaterials[24].LitSphere = openbitmap "C:\GoMAX\Material\Library\sphere_map.jpg"
				if doesFileExist "C:\GoMAX\Material\GoMAX_N.PSD" do -- checks if there is a normal map to avoid error message, however if there is an old normal map that map will be applied /bjorn
					(
					meditMaterials[24].UseNormalMap = on
					sleep 0.25
					meditMaterials[24].NormalMap = openbitmap "C:\GoMAX\Material\GoMAX_N.PSD"
					)
				meditMaterials[24].DiffuseColour = color 0 0 0 0
				$.material = meditMaterials[24]
				)
		
		)
)
	

----------------------------------------------------------------------------------------------------
-- Main rollout menu:
----------------------------------------------------------------------------------------------------


rollout GoMaxButtons "" 
(
	
	----------------------------------------------------------------------------------------------------
	--The GUI:
	----------------------------------------------------------------------------------------------------
	
		label versiontext "GoMax 1.2"
		button ZBexport width:100 height:54
		button ZBimport width:100 height:54
		label abouttext "by Norman Schaar"
		label wwwtest "www.norman3d.com"

	
fn updateButtons =
(
	max2zbBMP = "C:\\GoMAX\\max_to_zb.bmp"
	zb2maxBMP = "C:\\GoMAX\\zb_to_max.bmp"
	ZBimport.images = #(max2zbBMP, undefined, 1,1,1,1,1 )
	ZBexport.images = #(zb2maxBMP, undefined, 1,1,1,1,1 )
) 
	
	
    ----------------------------------------------------------------------------------------------------
	--The event handling/logic stuff:
	----------------------------------------------------------------------------------------------------
	

			on ZBimport pressed do
				(
					macros.run "Norman3D" "ZBrush_Import"
				)
			on ZBexport pressed do
				(
					macros.run "Norman3D" "ZBrush_Export"
				)

				
on GoMaxButtons open do updateButtons()
)

----------------------------------------------------------------------------------------------------
-- Create the final dialog:
----------------------------------------------------------------------------------------------------

createDialog GoMaxButtons width:100 bgcolor:(color 48 48 48)


